/*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :   Apr 13 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief Call to HOSTQA_ATP_Message with appropriate params
   *
   *  \version  SST_Ext_ATP_Utility.c#1:csrc:1
   *  \author   taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/

#include "SST_Ext_ATP_InitTerminate.h"
#include "ExtApp_HOST_TST_Message.h"
#include "SST_Ext_ATP_DataTstVectors.h"
#include "MW_ATP_UTIL_funcs.h"
#include "NVS.h"
#include "DX_VOS_File.h"
#include "SST_EXT_TST.h"
#include "ExtApp_qa_op_code.h"
#include "ExtApp_HOST_TST_Message_Init.h"
          



 #if TST_USE_INIT_TERMINATE_MODULE
/************************ Global Data **************************/
extern DxError_t      EXT_TST_ATP_Error;
extern DxUint8_t      EXT_FailureFunctionNameOut[TST_FUNC_STRING_LEN];
extern DxError_t      EXT_TST_TestStatus;
extern DxChar         TST_Ext_MainDBPool[NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES];
extern DxChar         TST_Ext_SecondaryDBPool[NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES];
extern DxVosFile      TST_Ext_MainDBFileHandle;
extern DxVosFile      TST_Ext_SecondaryDBFileHandle;
extern DxByte_t       TST_Ext_Workspace[TST_WORKSPACE_SIZE_BYTES];

/*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_InitTerminate      
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *   Verify that init and terminate commands work
 *  
 * Algorithm:       
 *    1.  Terminate the SST. 
 *    2.  Open files and get files handle.
 *    3.  Init the SST.
 *    4.  Terminate the SST.
 *    5.  Call HOSTQA_ATP_Message_Init(first part). 
 *    6.  Terminate the SST.
 *    7.  Init the SST
 *    8.  Call HOSTQA_ATP_Message_Init(second part)
 *    9.  Terminate the SST.
 *	  10. Init the SST
 *******************************************************************************/ 
 
 
 DxError_t SST_Ext_ATP_InitTerminate(  )
 {
 	
 
   /********* TST Variables Definitions ************/
    char                          TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_Ext_ATP_InitTerminate";
    SSTInitInfo_t                 aInitInfo;
    Ext_ATP_DataOpTestDataStruct  SEP_ATP_InitTerminateData[]={0};
   /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
	
	ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_MasterTestName,"\n"));
	
	/* copy SEP_ATP_DataOpTestData data to local SEP_ATP_InitTerminateData*/ 
	DX_VOS_FastMemCpy(SEP_ATP_InitTerminateData,
	                  SEP_ATP_DataOpTestData,
 	                  sizeof(Ext_ATP_DataOpTestDataStruct));

	
	/* Terminate the SST */
    /*-------------------*/
    EXT_TST_ATP_Error = SST_Terminate();

    EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Terminate", 
		                                          "SST_Ext_ATP_InitTerminate",TST_MasterTestName);											
  
    if (EXT_TST_TestStatus!=TST_PASS)
       goto EXIT;

    /*open files and get files handle*/
	#ifndef DX_NVS_RAM

		EXT_TST_TestStatus =DX_VOS_FClose(TST_Ext_MainDBFileHandle);
		if (EXT_TST_TestStatus == DX_FAILURE)
        {
			 DX_VOS_Printf("CANT CLOSE MAIN FILE \n");
			goto EXIT;
        }
        
		EXT_TST_TestStatus = DX_VOS_FOpen(&TST_Ext_MainDBFileHandle,SST_DB_FILENAME ,"w+b");
        if (EXT_TST_TestStatus == DX_FAILURE)
        {
			DX_VOS_Printf("CANT OPEN MAIN FILE \n");
			goto EXIT;
        }

        EXT_TST_TestStatus =DX_VOS_FClose(TST_Ext_SecondaryDBFileHandle);
        if (EXT_TST_TestStatus == DX_FAILURE)
        {
		    DX_VOS_Printf("CANT CLOSE SECONDARY FILE \n");
			goto EXIT;
        }

        EXT_TST_TestStatus = DX_VOS_FOpen(&TST_Ext_SecondaryDBFileHandle,SST_DB_FILENAME_SECOND ,"w+b");
        if (EXT_TST_TestStatus == DX_FAILURE)
        {
			DX_VOS_Printf("CANT OPEN SECONDARY FILE \n");
			goto EXIT;
        }
		#else
			DX_VOS_MemSetZero(TST_Ext_MainDBPool,NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES);
			DX_VOS_MemSetZero(TST_Ext_SecondaryDBPool,NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES);
          
	#endif

	/* Init the SST for operations */
	/*-----------------------------*/
	EXT_TST_ATP_Error = SST_Init((DxNvsMemoryId_t)TST_Ext_MainDBFileHandle,
                                (DxNvsMemoryId_t)TST_Ext_SecondaryDBFileHandle,
                                &aInitInfo,
                   				TST_Ext_Workspace,
                   				TST_Ext_WorkspaceSizeInBytes);

     EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Init", 
		                                          "SST_Ext_ATP_InitTerminate",TST_MasterTestName);											
   
    if (EXT_TST_TestStatus!=TST_PASS)
       goto EXIT;
    
    if(aInitInfo.newDatabase == DX_TRUE)
		 EXT_TST_TestStatus = TESTPASS; 
	else
         EXT_TST_TestStatus = TESTFAIL;
	
	/* Validation of new database */
 	/*-----------------------------*/
	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_TestStatus,"Validation of new database", 
		                                          "SST_Ext_ATP_InitTerminate",TST_MasterTestName);											
  
	if (EXT_TST_TestStatus!=TST_PASS)
       goto EXIT;
	
	/* Call HOSTQA_ATP_Message_Init(first part) */
	/*------------------------------------------*/
	
	EXT_TST_ATP_Error = HOSTQA_ATP_Message_Init (DX_SEP_HOST_SEP_PROTOCOL_SST_InitTerminate_1_OP_CODE,
	                                             SEP_ATP_InitTerminateData);
			
								 
	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"HOSTQA_ATP_Message", 
		                                         "SST_Ext_ATP_InitTerminate",TST_MasterTestName);
                                       
    
    if (EXT_TST_TestStatus!=TST_PASS)
       goto EXIT;		                                          
		                                          
	/* Terminate the SST */
    /*-------------------*/
    EXT_TST_ATP_Error = SST_Terminate();

    EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Terminate", 
		                                          "SST_Ext_ATP_InitTerminate",TST_MasterTestName);											
  
    if (EXT_TST_TestStatus!=TST_PASS)
       goto EXIT;

	/* Init the SST for operations */
	/*-----------------------------------*/
      EXT_TST_ATP_Error = SST_Init((DxNvsMemoryId_t)TST_Ext_MainDBFileHandle,
                   (DxNvsMemoryId_t)TST_Ext_SecondaryDBFileHandle,
                   &aInitInfo,
                   TST_Ext_Workspace,
                   TST_Ext_WorkspaceSizeInBytes);

   	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Init", 
		                                          "SST_Ext_ATP_InitTerminate",TST_MasterTestName);											

    if (EXT_TST_TestStatus!=TST_PASS)
       goto EXIT;  
    
    /* Call HOSTQA_ATP_Message_Init(second part) */
	/*-------------------------------------------*/
								
  
   	EXT_TST_ATP_Error = HOSTQA_ATP_Message_Init (DX_SEP_HOST_SEP_PROTOCOL_SST_InitTerminate_2_OP_CODE,
   	                                             SEP_ATP_InitTerminateData);
													 
	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Ext_ATP_InitTerminate", 
		                                          "HOSTQA_ATP_Message_Init",TST_MasterTestName);
   
    if (EXT_TST_TestStatus!=TST_PASS)
       goto EXIT;
	                                          
	
	
		/* Terminate the SST */
    /*-------------------*/
    EXT_TST_ATP_Error = SST_Terminate();

    EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Terminate", 
		                                          "SST_Ext_ATP_InitTerminate",TST_MasterTestName);											
  
    if (EXT_TST_TestStatus!=TST_PASS)
       goto EXIT;

	/* Init the SST again for operations */
	/*-----------------------------------*/
      EXT_TST_ATP_Error = SST_Init((DxNvsMemoryId_t)TST_Ext_MainDBFileHandle,
                   (DxNvsMemoryId_t)TST_Ext_SecondaryDBFileHandle,
                   &aInitInfo,
                   TST_Ext_Workspace,
                   TST_Ext_WorkspaceSizeInBytes);

	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Init", 
		                                          "SST_Ext_ATP_InitTerminate",TST_MasterTestName);											
   
	if (EXT_TST_TestStatus!=TST_PASS)
		 goto EXIT;	                                          
		                                          											
  
    EXIT: 
    
		  return EXT_TST_TestStatus;												                        
 }
 #endif

